<?php
namespace model;

class Category extends \Pawn\Model
{
	// Migration
	public static function migration($model_name, $current)
	{
		if($current && version_compare(UPDATE, '1.1.2', '<'))
		{
			\lib\db::query('UPDATE `'.PREFIX.'category` SET `name`="Dress-Up" WHERE `name`="Dress Up"');
		}
		
		return array
		(
			array('CREATE', array
			(
				'name'		=>	'VARCHAR(64)',
				'games'		=>	'INT',
				'enabled'	=>	'TINYINT'
			)),
			array('POPULATE', array
			(
				array('Action', 0, 1),
				array('Adventure', 0, 1),
				array('Board game', 0, 1),
				array('Casino', 0, 1),
				array('Driving', 0, 1),
				array('Dress-Up', 0, 1),
				array('Fighting', 0, 1),
				array('Puzzles', 0, 1),
				array('Pimp my / Customize', 0, 1),
				array('Shooting', 0, 1),
				array('Sports', 0, 1),
				array('Other', 0, 1),
				array('Strategy', 0, 1),
				array('Education', 0, 1),
				array('Rhythm', 0, 1),
				array('Jigsaw / Slider Puzzles', 0, 1)
			)),
			array('QUERY', 'UPDATE `'.static::table_name().'` SET `name`="Dress Up" WHERE `name`="Dress-Up"')
		);
	}
	
	// Identifier
	public function __toString()
	{
		return \lib\Lang::get('categories', str_replace(' ', '_', strtolower($this->name)));
	}
	
	// Administration
	const sortColumn = 'name';
	
	public function listing()
	{
		return array
		(
			'name'		=>	$this->__toString(),
			'enabled'	=>	$this->img_enabled($this->enabled),
			'games'		=>	$this->games
		);
	}
	
	public static function bulk()
	{
		return array
		(
			'enable'	=>	false,
			'disable'	=>	false
		);
	}
	
	// Enable
	public function enable()
	{
		$this->enabled = 1;
	}
	
	// Disable
	public function disable()
	{
		$this->enabled = 0;
	}
}